<?php

namespace  App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'region_id', 'password');

    public function orders()
    {
        return $this->hasMany(' App\Models\Order', 'client_id');
    }

    public function region()
    {
        return $this->belongsTo(' App\Models\Region', 'region_id');
    }

    public function reviews()
    {
        return $this->hasMany(' App\Models\Review', 'client_id');
    }

}